﻿using UnityEngine;

namespace CaveFixer
{
    [KSPAddon(KSPAddon.Startup.MainMenu, false)]
    public class CaveFixer : MonoBehaviour
    {
        public CelestialBody cb_sun = null;
        public CelestialBody cb_tylo = null;

       void Start()
        {
            if (HighLogic.LoadedScene == GameScenes.MAINMENU)
            {
                foreach (CelestialBody cb in FlightGlobals.Bodies)
                {
                    if (cb.gameObject.name == "Sun")
                    {
                        cb_sun = cb; // Is there a sun? :D
                    }

                    if (cb.gameObject.name == "Tylo")
                    {
                        cb_tylo = cb;
                        print("CaveFixer: Found Tylo");
                    }
                }
                
                if (cb_sun != null && cb_tylo != null)
                {
                    PQSCity cave = cb_tylo.pqsController.transform.FindChild("Cave").GetComponent<PQSCity>();
                    print("CaveFixer: Searching Caves");
                    if (cave != null)
                    {
                        cave.repositionRadiusOffset = 2518;
                        print("CaveFixer: Found Cave and fixed it");
                    }
                    cb_tylo.CBUpdate();
                }
            }
       }
    }
}
